/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Rread.c	1.15 87/05/21
*/

/*
**	Remote read for handler
*/

#define	TERMIOCTL

#include	"global.h"
#include	"debug.h"
#include	"command.h"

#include	<setjmp.h>
#if	DEBUG >= 1
#include	<errno.h>
#endif	DEBUG >= 1

#include	"Channel.h"

#include	"daemon.h"
#include	"Stream.h"
#include	"driver.h"


extern int	DevSpeed;
extern jmp_buf	IOerrorbuf;

#ifdef	VCBUFSIZE
static char	PktBuf[VCBUFSIZE];
static int	PktSize;
static char *	PktPtr;
#endif	VCBUFSIZE



void
Rread(data, size, alrm_on, alrm_off)
	register char *	data;
	register int	size;
	bool		alrm_on;
	bool		alrm_off;
{
	register int	n;
#	if	DEBUG >= 1
	char *		d = data;
	int		s = size;
	static int	syncs;
#	endif	DEBUG >= 1

	if ( alrm_on )
		IOALRMON(ScanRate);

	if ( Wbufcount )
		(void)RWflush(RemoteFd);

#	if	DEBUG == 2
	if ( size > 1 )
	{
		if ( syncs )
		{
			Trace2(2, "%d*Rread 1", syncs);
			syncs = 0;
		}

		Trace6
		(
			2,
			"Rread %d  on=%d, off=%d, scan=%d, time=%ld",
			size,
			alrm_on,
			alrm_off,
			ScanRate,
			time((long *)0)
		);
	}
	else
	if ( size == 1 )
		syncs++;
#	endif	DEBUG == 2

#	ifdef	VCBUFSIZE
	while ( size > 0 )
	{
		if ((n = PktSize) == 0)
		{
			if ( (n = read(RemoteFd, PktBuf, sizeof PktBuf)) == 0 )
			{
				Trace1(1, "Rread ZERO");
				pause();	/* Await timeout */
			}
			else
			if ( n < 0 )
			{
#				if	DEBUG >= 1
				if ( errno == EINTR )
					continue;
#				endif	DEBUG
				longjmp(IOerrorbuf, 1);
				break;
			}

			PktSize = n;
			PktPtr = PktBuf;
		}

		if ( n > size )
			n = size;

		bcopy(PktPtr, data, n);

		PktPtr += n;
		PktSize -= n;

		data += n;
		size -= n;
	}

#	else	VCBUFSIZE

	if ( size > 0 )
		while ( (n = read(RemoteFd, data, size)) != size )
		{
			if ( n >= 0 )
			{
			 	if ( n == 0 )
				{
					Trace1(1, "Rread ZERO");
					pause();	/* Await timeout */
				}
				else
				{
					if ( PprotoT == PT_DATAGRAM )
					{
						DODEBUG(s = n);
						break;
					}

					Trace2(2, "Rread part=%d", n);

					data += n;
					size -= n;
				}
			}
			else
			{
#				if	DEBUG >= 1
				if ( errno == EINTR )
					continue;
#				endif	DEBUG
				longjmp(IOerrorbuf, 1);
				break;
			}
		}

#	endif	VCBUFSIZE

	if ( alrm_off )
	{
		IOALRMOFF();
		NNstate.inpkts++;
	}

	Trace2(3, "Rread \"%s\"", ExpandString(d, s));
}
