static char sccsid[] = "@(#)scitec.c	1.1 (Neology) 85/09/17";
/*
**	patterns and functions to call using scitec modems
*/

#include	"global.h"
#include	"caller.h"

#define TRACE

/*
**	The following PASSWD stuff is imported from "passwd.q"
*/

#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif
#ifndef	CALLTIMES
#define	CALLTIMES	"calltimes"
#endif	CALLTIMES

#define	MAXPHONES	8

extern	int	Traceflag;

char
	*callargs = CALLARGS,	
	*daemon1 = NNDAEMON,		/* standard daemon */
	*daemon2 = NN2DAEMON,		/* alternate protocol */
	*hostflg = "-BF",		/* dialup, don't fork, cooked */
	*host	 	= NULLSTR,	/* connecting from where? */
	*target  	= NULLSTR,	/* connecting to where? */
	*passwd  	= NULLSTR,
	*ph_num[MAXPHONES + 1],		/* table of phone numbers */
	**phoneno	= ph_num,	/* Phone sequence for call unit */
	*device  	= NULLSTR,	/* Which call unit? (cul0) */
	*speed   	= "2400",
	*opentime	= "30",
	*dialtime	= "60";		/* MUST be greater then 15 seconds
						(modem carrier detect time) */

int
	connected= 0,	/* remote system has answered */
	tcount	 = 0,	/* count of timeouts */
	lcount	 = 0;	/* count of Unix login attempts */

int
	eof(),
	gotlogin(),
	gotpasswd(),
	ignoreline(),
	start2(),
	started(),
	timeout();

struct patlist patterns[] =
{
	{ "[Ii]llegal", ignoreline },
	{ "[Ii]ncorrect", ignoreline },
	{ "[Ll]ogin", gotlogin },
	{ "[Pp]assword", gotpasswd },
	{ STARTMSG, started},
	{ START2MSG, start2 },	/* alternate protocol */
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};

args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'd':
					device = ++*argv;
					goto break2;
				case 's':
					speed = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case 'p':
					if (phoneno != &ph_num[MAXPHONES])
					{
					    *phoneno++ = ++*argv;
					    goto break2;
					}
					outend("fail too many phone numbers");
					exit(1);
				case 'P':
					passwd = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					outend(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else if (target != NULLSTR)
		{
			out("fail target already given: \"");
			out(*argv);
			outend("\" unexpected.");
			exit(1);
		}
		else
			target = *argv;
	}
}

init(argc, argv)
	int	argc;
	char	*argv[];
{

	args(argc, argv);
	if (target == NULLSTR)
	{
	    outend("fail no target");
	    exit(1);
	}

	callargs = concat(SPOOLDIR(/), target, "/", callargs, NULLSTR);
	(void)readargs(callargs, args);
	phoneno = ph_num;
	if (*phoneno == NULLSTR)
	{
	    outend("fail no phone numbers");
	    exit(1);
	}
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace opening line......");
#endif	TRACE
	out("timeout "); outend(opentime);
	out("opendial "); outend(device);
	outend("local");
	out("speed "); outend(speed);
	out("timeout "); outend(dialtime);
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace starting reader ......");
#endif	TRACE
	outend("read");
#ifdef	TRACE
	if (Traceflag > 1 )
		outend("trace dialing......");
#endif	TRACE
	out("write CRN"); out(*phoneno++); outend("\r\n");
	if (*phoneno == NULLSTR)
	    phoneno = ph_num;
	state(patterns);
	reset();
}

ignoreline()
{
	reset();
}

gotlogin()
{
	++connected;
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace got login ......");
#endif	TRACE
	if ( ++lcount >= 9 )
	{
		out("fail too many login attempts at "); outend(target);
	}
	out("write "); out(host); outend("\r");
	reset();
}


gotpasswd()
{
	++connected;
#ifdef	TRACE
	if (Traceflag > 5 )
		outend("trace got passwd ......");
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	reset();
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("succeed "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 9)
	{
		outend("fail 9 timeouts in login");
		exit(1);
	}
	if (connected)
		outend("write @\r");
	else
	{
		/* redial */
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace reset......");
#endif	TRACE
		outend("close");
		outend("sleep 4");
		sleep(4);
		out("timeout "); outend(opentime);
		out("opendial "); outend(device);
		outend("local");
		out("speed "); outend(speed);
		out("timeout "); outend(dialtime);
		outend("read");
#ifdef	TRACE
		if (Traceflag > 1 )
			outend("trace dialing......");
#endif	TRACE
		out("write CRN"); out(*phoneno++); outend("\r\n");
		if (*phoneno == NULLSTR)
		    phoneno = ph_num;
	}
	reset();
}

eof()
{
	outend("fail unexpected eof");
	exit(1);
}
