/*
**	Patterns and functions to call a host via an X.29 PAD.
**
**	SCCSID %W% %E%
*/

#include	"global.h"
#include	"debug.h"

#include	"caller.h"

#define	MAXDEV	8			/* Maximum specifiable alternate devices */


char
	*CallArgs= CALLARGS,		/* optional args for call */
	*Daemon1 = NNDAEMON,		/* standard daemon */
	*Daemon2 = CNDAEMON,		/* alternate protocol */
	*Daemon3 = PNDAEMON,		/* alternate protocol */
	*HostFlg = "-BF";		/* batch mode, no fork */

char
	*PadReq,			/* Request to set-up virtual circuit */
	*Device,			/* Device for link */
	*Host,				/* Who am i */
	*Passwd,			/* Password at Target */
	*Retries = "3",			/* Number of retries */
	*Retry   = "30",		/* Retry sleep time */
	*Speed,				/* Speed of link */
	*Target,			/* Target host */
	*TimeOut = "15";		/* Timeout for open */

int
	DefFlag	 = '2',			/* Default daemon to start [1,2,3] */
	Devices  = 0,			/* Count of device names if separate "-d" args */
	Tcount	 = 0,			/* count of Timeouts */
	Ccount	 = 0,			/* count of PAD login attempts */
	Lcount	 = 0,			/* count of Unix login attempts */
	Wait	 = 4;			/* Minutes to wait after failure */

int
	AtPAD(),
	AtUNIX(),
	DefStart(),
	EchoOff(),
	FindEcho(),
	GotEof(),
	GotLogin(),
	GotPasswd(),
	GotTimeout(),
	NoShellFail(),
	Start1(),
	Start2(),
	Start3(),
	ToPAD(),
	ToUNIX(),
	UNIXfail();

#define	PADfail	UNIXfail

/*
**	PAD messages
*/

char	Connect[]	= "^> com";
char	Disconn[]	= "clear cause";
char	InvCom[]	= "invalid command";
char	OutOfOrder[]	= "out of order";
char	NotObtainable[]	= "not obtainable";
char	PadEcho[]	= ".1.echo";
char	PadNoEcho[]	= ".0.no echo";
char	Prompt[]	= "clr";

/*
**	PAD commands
*/

char	EnqEcho[]	= "par?2\r";
char	ClearEcho[]	= "set?2:0\r";
char	ClearPad[]	= "\020\rclr\r";

/*
**	Other common patterns
*/

char	Eof[]		= EOFSTR;
char	Login[]		= "[Ll]ogin";
char	LoginI[]	= "[Ll]ogin +[Ii]ncorrect";
char	Password[]	= "^[Pp]assword";
char	WPassword[]	= "[Ww]rong +[Pp]assword";
char	Timeout[]	= TIMEOUT;

/*
**	The pattern/action sets
*/

PatList	PADnet[] =
{
	/*{ InvCom, ToPAD },*/
	{ Connect, ToUNIX },
	{ Prompt, FindEcho },
	{ PadEcho, EchoOff },
	{ PadNoEcho, AtPAD },
	{ OutOfOrder, PADfail },
	{ NotObtainable, PADfail },
	{ Timeout, GotTimeout },
	{ Eof, GotEof },
	{ 0, 0}
};

PatList UNIXnet[] =
{
	/*{ LoginI, ToPAD },*/
	/*{ WPassword, AtUNIX },*/
	/*{ Login, GotLogin },*/
	{ Password, GotPasswd },
	{ "login.* Connected\..*CN", Start2 },
	{ "login.* Connected\..*PN", Start3 },
	{ "login.* Connected\.", DefStart },
	{ NNSTARTS, Start1 },
	{ CNSTARTS, Start2 },
	{ PNSTARTS, Start3 },
	{ NOGOMSG, UNIXfail },
	{ "no shell", UNIXfail },
	{ "daemon: error", UNIXfail },
	{ Disconn, ToPAD },
	{ Timeout, GotTimeout },
	{ Eof, GotEof },
	{ 0, 0 }
};



/*
**	Function to process arguments, either from NNcall, or from CALLARGS.
*/

void
Args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( Traceflag >= 2 )
			Command("trace Args: \"", argv[1], "\"", NULLSTR);

		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case '1':
					if ( *++*argv )
						Daemon1 = *argv;
					DefFlag = c;
					goto break2;

				case '2':
					if ( *++*argv )
						Daemon2 = *argv;
					DefFlag = c;
					goto break2;

				case '3':
					if ( *++*argv )
						Daemon3 = *argv;
					DefFlag = c;
					goto break2;

				case 'R':
					Retries = ++*argv;
					goto break2;

				case 'T':
					if ( (Traceflag = atoi(++*argv)) == 0 )
						Traceflag = 1;
					goto break2;

				case 'd':
					if ( Devices >= MAXDEV )
					{
						Command
						(
							"fail too many devices in ",
							CallArgs,
							NULLSTR
						);
						exit(1);
					}
					if ( Devices++ == 0 )
						Device = ++*argv;
					else
						Device = concat(Device, " ", ++*argv, NULLSTR);
					goto break2;

				case 'l':
					Host = ++*argv;
					goto break2;

				case 'p':
					Passwd = ++*argv;
					goto break2;

				case 'r':
					Retry = ++*argv;
					goto break2;

				case 's':
					Speed = ++*argv;
					goto break2;

				case 't':
					TimeOut = ++*argv;
					goto break2;

				case 'v':
					PadReq = ++*argv;
					goto break2;

				case 'w':
					Wait = atoi(++*argv);
					break;
					
				default:
					Command
					(
						"fail unexpected flag \"-",
						*argv,
						"\" in ",
						CallArgs,
						NULLSTR
					);
					exit(1);
				}
			}
break2:			;
		}
		else
			Target = *argv;
	}
}



init(argc, argv)
	int		argc;
	char *		argv[];
{
	register char *	cp;

	Host = NodeName();

	Args(argc, argv);

	if ( Target != NULLSTR )
		CallArgs = concat(SPOOLDIR(), Target, "/", CallArgs, NULLSTR);
	else
	{
		if ( (cp = strrchr(*argv, '/')) != NULLSTR )
		{
			*cp = '\0';
			cp = *argv;
		}
		else
			cp = ".";

		CallArgs = concat(cp, "/", CallArgs, NULLSTR);
	}
	(void)readargs(CallArgs, Args);

	DODEBUG
	(
		if
		(
			Target == NULLSTR
			||
			Passwd == NULLSTR
			||
			PadReq == NULLSTR
			||
			Device == NULLSTR
		)
		{
			Command("fail incomplete initialisation", NULLSTR);
			exit(1);
		}
	);

	Command("retry ", Retry, " ", Retries, NULLSTR);
	Command("timeout ", TimeOut, NULLSTR);
	Command("open ", Device, NULLSTR);
	if ( Speed != NULLSTR )
		Command("speed ", Speed, NULLSTR);
	Command("read", NULLSTR);

	ToPAD();
}



ToPAD()
{
	Tcount = 0;
	flushinput();
	Command("write ", ClearPad, NULLSTR);
	state(PADnet);
	reset();
}



AtPAD()
{
	if ( ++Ccount >= 7 )
	{
		Command("fail PAD setup failed", NULLSTR);
		exit(1);
	}

	Command("write ", PadReq, "\r", NULLSTR);
	reset();
}



ToUNIX()
{
	Tcount = 0;
	Lcount = 0;

	state(UNIXnet);
	reset();
}



AtUNIX()
{
	if ( ++Lcount >= 7 )
	{
		Command("fail too many login attempts at ", Target, NULLSTR);
		exit(1);
	}

	Command("sleep 10", NULLSTR);
	flushinput();
	Command("write \r", NULLSTR);
	reset();
}



GotLogin()
{
	if ( ++Lcount >= 7 )
	{
		Command("fail too many login attempts at ", Target, NULLSTR);
		exit(1);
	}

	Command("write ", Host, "\r", NULLSTR);
	reset();
}



GotPasswd()
{
	if ( Passwd == NULLSTR )
		Command("write \r", NULLSTR);
	else
		Command("write ", Passwd, "\r", NULLSTR);
	reset();
}



DefStart()
{
	switch ( DefFlag )
	{
	default:
	case '1':
		Start1();
		break;
	case '2':
		Start2();
		break;
	case '3':
		Start3();
		break;
	}
}



Start1()
{
	Command("daemon ", Daemon1, NULLSTR);
	Command("succeed ", HostFlg, " ", Target, NULLSTR);
	sleep(2);
	exit(0);
}



Start2()
{
	Command("daemon ", Daemon2, NULLSTR);
	Command("succeed ", HostFlg, " ", Target, NULLSTR);
	sleep(2);
	exit(0);
}



Start3()
{
	Command("daemon ", Daemon3, NULLSTR);
	Command("succeed ", HostFlg, " ", Target, NULLSTR);
	sleep(2);
	exit(0);
}



GotTimeout()
{
	if ( ++Tcount >= 3 )
	{
		Command("fail TIMEOUT", NULLSTR);
		exit(1);
	}

	if ( current == PADnet )
		Command("write ", ClearPad, NULLSTR);
	else
		Command("write @\r", NULLSTR);

	reset();
}



GotEof()
{
	Command("fail unexpected EOF", NULLSTR);
	exit(1);
}



UNIXfail()
{
	Command("fail ", input, NULLSTR);
	exit(1);
}


FindEcho()
{
	Command("write ", EnqEcho, NULLSTR);
	reset();
}


EchoOff()
{
	Command("write ", ClearEcho, NULLSTR);
	reset();
}
