/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)state.h	1.20 89/10/30
*/

/*
**	Node/Link states
**
**	(The order of these must be maintained.)
*/

enum
{
	s_down, s_msg, s_con, s_lan,
	s_conterminal, s_call, s_msgterminal, s_foreign,
	s_local, s_found, s_dead, s_print,
	s_filtered, s_spare1, s_intermittent, s_spare2,
#	define	s_max	s_spare2
	s_fast, s_cheap, s_domains, s_domroute, s_printroute,	/* Routing flags */
	s_linkforw
};

typedef unsigned short	States;					/* Enough for ``s_max'' bits */
typedef ulong		Rflags;					/* Enough bits for enum */

#ifndef	unreasonable

#define	S_CALL		(States)(1L<<(int)s_call)		/* Call on demand */
#define	S_CHEAP		(Rflags)(1L<<(int)s_cheap)		/* Use cheapest route */
#define	S_CON		(States)(1L<<(int)s_con)		/* Link allows connection protocol */
#define	S_CONTERMINAL	(States)(1L<<(int)s_conterminal)	/* Virtual circuits may not be connected through */
#define	S_DEAD		(States)(1L<<(int)s_dead)		/* Link appears dead */
#define	S_DOMAINS	(Rflags)(1L<<(int)s_domains)		/* Find domain routes */
#define	S_DOMROUTE	(Rflags)(1L<<(int)s_domroute)		/* Set domain broadcast routes */
#define	S_DOWN		(States)(1L<<(int)s_down)		/* Link is down */
#define	S_FAST		(Rflags)(1L<<(int)s_fast)		/* Use fastest route */
#define	S_FILTERED	(States)(1L<<(int)s_filtered)		/* A ``filter'' has been put on link */
#define	S_FOREIGN	(States)(1L<<(int)s_foreign)		/* Link uses foreign protocols - use special handlers */
#define	S_FOUND		(States)(1L<<(int)s_found)		/* Node has been identified */
#define	S_INTERMITTENT	(States)(1L<<(int)s_intermittent)	/* Intermittent link */
#define	S_LAN		(States)(1L<<(int)s_lan)		/* Link uses Local Area Network */
#define	S_LOCAL		(States)(1L<<(int)s_local)		/* Node is "local" - details not exported */
#define	S_MSG		(States)(1L<<(int)s_msg)		/* Link allows Message transfer */
#define	S_MSGTERMINAL	(States)(1L<<(int)s_msgterminal)	/* Messages may not be routed through */
#define	S_PRINT		(States)(1L<<(int)s_print)		/* Node marked for printing */
#define	S_PRINTROUTE	(Rflags)(1L<<(int)s_printroute)		/* Route marked for printing */
#define	S_LINKFORW	(Rflags)(1L<<(int)s_linkforw)		/* Set link forwarding table */

#else	unreasonable

#define	S_DOWN		1
#define	S_MSG		2
#define	S_CON		4
#define	S_LAN		8
#define	S_CONTERMINAL	16
#define	S_CALL		32
#define	S_MSGTERMINAL	64
#define	S_FOREIGN	128
#define	S_LOCAL		256
#define	S_FOUND		512
#define	S_DEAD		1024
#define	S_PRINT		2048
#define	S_FILTERED	4096
#define	S_SPARE1	8192
#define	S_INTERMITTENT	16384
#define	S_SPARE2	32768
#define	S_FAST		65536
#define	S_CHEAP		131072
#define	S_DOMAINS	262144
#define	S_DOMROUTE	524288
#define	S_PRINTROUTE	1048576
#define	S_LINKFORW	2097152

#endif	unreasonable

/**	Re-declare some link flags for use by domains **/
#define	S_HIERDOM	S_DOWN	/* This domain is in our hierarchy */
#define	S_OTHDOM	S_CALL	/* This (top-level) domain can be reached */
#define	S_OURDOM	S_LOCAL	/* We are member of this domain */
#define	S_TOPDOM	S_LAN	/* This domain is the highest in its hierarchy */

#define	LINK_FLAGS	(S_DOWN|S_MSG|S_CON|S_CALL|S_LAN|S_LOCAL|S_INTERMITTENT|S_DEAD|S_FILTERED)
#define	NODE_FLAGS	(S_MSGTERMINAL|S_CONTERMINAL|S_FOREIGN|S_LOCAL)
#define	FOREIGN_FLAGS	(S_DOWN|S_MSG|S_CON|S_MSGTERMINAL|S_CONTERMINAL|S_FOREIGN|S_LOCAL|S_INTERMITTENT|S_DEAD|S_FILTERED)
#define	EXTERNAL_FLAGS	(LINK_FLAGS|NODE_FLAGS)

#ifdef	FLAG_DATA
/*
**	These must match order declared for "States".
*/

static char	_unk[]		= "(unknown)";

static char *	FlagNames[] =
{
	"down", "msg", "con", "lan",
	"conterm", "call", "msgterm", "foreign",
	"local", _unk, "dead", _unk,
	"filtered", _unk, "int", _unk
};
#endif	FLAG_DATA

/*
**	Home flags
*/

Extern States		HomeFlags;

/*
**	Structure set up by routing functions
*/

typedef struct
{
	char *	nl_name;	/* Name of node on shortest path (the "link") */
	char *	nl_spooler;	/* Spooler program if non-null */
	char *	nl_connector;	/* Connector program if non-null */
	char *	nl_caller;	/* Virtual circuit call set-up program if non-null */
	char *	nl_filter;	/* Filter program if non-null */
	States	nl_flags;	/* Combined flags for node and link */
	short	nl_index;	/* Index of destination node in node table */
	short	nl_link;	/* Index of link node in link table */
	short	nl_domind;	/* Index of destination (primary) domain in domain table */
}
			NodeLink;

/*
**	Enumerate shortest path types
*/

typedef enum
{
	pt_msg, pt_con, pt_n
}
			Path_t;

#define	PT_MSG		(int)pt_msg
#define	PT_CON		(int)pt_con
#define	PT_N		(int)pt_n

/*
**	Enumerate statistics types
*/

typedef enum
{
	st_link, st_from, st_to
}
			Stats_t;

/*
**	Routing parameters -- DON'T CHANGE!
*/

#define	MSG_ROUTING	((Rflags)S_MSG|S_CHEAP|S_FAST)
#define	CON_ROUTING	((Rflags)S_CON|S_FAST)

/*
**	Function declarations
*/

extern char *		AdjustSource();
extern bool		CheckConnectivity();
extern bool		CheckState();
extern char *		DomainName();
extern char *		DomInHier();
extern char *		DomInPrim();
extern bool		FindAddress();
extern char *		FindAlias();
extern bool		FindDomain();
extern bool		FindNode();
extern bool		GetLink();
extern char *		Hierarchy();
extern bool		HomeDomain();
extern bool		NodeinPrim();
extern void		Paths();
extern int		PrimDom();
extern void		PrintAlias();
extern void		PrintDomains();
extern void		PrintOnly();
extern void		PrintRoute();
extern void		PrintState();
extern void		Printstates();
extern void		RdStCommands();
extern void		Rcommands();
extern bool		ReadRoute();
#ifdef	BUFSIZ
extern FILE *		ReadState();
#endif	BUFSIZ
extern void		Rstate();
extern void		SetCommands();
extern States		SetPrint();
extern void		SetRoute();
extern void		SetState();
extern bool		Stats();
extern bool		StatsFrom();
extern bool		StatsTo();
extern void		TraceNode();
extern void		WriteRoute();
extern void		WriteState();
