.\"OPTIONS	mm pic
.S 12
.nr Hy 0
.ds HF 3 3 2 2 2 2 2
.TL
SUN-III Schematic
.AF "Sydney University"
.AU "R.J.Kummerfeld"
.AU "P.R.Lauder"
.MT 4
.SA 1
.H 1 "Messages and Handlers"
.DS CB
.S 10
.PS
down
CR: ellipse wid 0.8 ht 0.3 "cron"
move down
SF: ellipse wid 0.8 ht 0.3 "sendfile"
move down
MA: ellipse wid 0.8 ht 0.3 "mailer"
move down
DD: ellipse wid 0.8 ht 0.3 "..."
move down
ST: ellipse wid 0.8 ht 0.3 "Stater"
RT: ellipse wid 0.8 ht 0.3 with .w at DD.e + (0.75, 0.4) "Router"
NT: ellipse wid 0.8 ht 0.3 with .n at RT.s + (0.0, -0.5) "Netstate"
NN: ellipse wid 0.8 ht 0.3 with .s at RT.n + (0.0, 0.5) "NNcall"
move up 0.25 then right from NN.n
box wid 0.4 ht 0.4 "call" "script"
line -> from last box to NN chop
line -> from SF to RT chop
line <- from DD.e to RT.w
line <- from MA.e to RT.w
line -> from RT to ST chop
line -> from ST.e to NT.w
line -> dashed from RT.n to NN.s
line -> dashed from CR to NN chop
move down 0.4 from NT.s
box wid 0.75 ht 0.4 "commands" "file"
line -> from last box.n to NT.s
move down 0.25 then right from NT.s
box wid 0.4 ht 0.4 "state" "file"
line <-> from last box to NT chop
move up 0.25 then right from NT.n
box wid 0.4 ht 0.4 "route" "file"
line -> from NT to last box chop
line -> from last box to RT chop
right
move right 0.25 from RT.e
Q: circle radius 0.15 "Q"
line <-> from RT.e to Q.w
move right 0.25 from Q.e
ND: ellipse wid 0.8 ht 0.3 "NNdaemon"
line <-> from Q.e to ND.w
line -> dashed from NN to ND chop
line from ND.e to ND.e + (0.125, 0.125) \
	then down 0.075 then right 0.5 then up 0.075 \
	then to ND.e + (0.75, 0) then to ND.e + (0.626, -0.125) \
	then up 0.075 then left 0.5 then down 0.075 \
	then to ND.e
circle radius 0.3 with .w at ND.e + (0.75, 0) "Remote" "Host"
.PE
.DE
.P
Messages (mail, file transfers etc.) from local users are passed to
.I router
which uses the
.I routefile
information to choose an appropriate host queue for the message.
It may also invoke
.I NNcall
if the link to the host is flagged for auto-calling.
.I NNdaemon
communicates with a copy of itself on a remote host to
exchange data reliably over a variety of communications links.
.P
Messages arriving from a remote hosts are passed by
.I router
to the appropriate handler,
.I mailer
for mail messages,
.I filer
for file transfers or
.I stater
for network state update messages.
State messages are passed to
.I netstate ,
which updates the
.I routefile
and
.I statefile .
Permanent modifications can be included in
.I commandsfile
and can override or cancel bogus network state
information.
.P
NNcall is instructed by the appropriate
.I call
script to make an
.I NNdaemon
connection to the remote host. By this means different
modems and/or network carriers can be utilised.
