BEGIN	{
	FS = ":"
	}
{
	handler		= $1
	direction	= $2
	from		= $3
	mach_from	= $4
	to		= $5
	mach_to		= $6
	size		= $7
	time_stamp	= $8
	env		= $9

	if (handler == "")
		next
	n = split(size, f_s, "@")
	n_bytes = f_s[1]
	n_msgs = f_s[2]
	t_bytes += n_bytes
	t_msgs += n_msgs
	if (handler == "stater")
		site = "STATER"
	else
	{
		if (handler == "reporter")
			site = "NEWS"
		else
		{
			site = mach_from
		}
	}
	if (direction == "I")
	{
		n_ib = n_bytes
		n_im = n_msgs
		n_ob = 0
		n_om = 0
	}
	else
	{
		n_ib = 0
		n_im = 0
		n_ob = n_bytes
		n_om = n_msgs
	}
	summ_ib[site] = summ_ib[site] + n_ib
	summ_im[site] = summ_im[site] + n_im
	summ_ob[site] = summ_ob[site] + n_ob
	summ_om[site] = summ_om[site] + n_om

}	END {
	for (s in summ_ib)
	{
		t_nb = t_nb + summ_ib[s]+summ_ob[s]
		t_nm = t_nm + summ_im[s]+summ_om[s]
		printf "%-20.20s\t%10ld bytes in %10ld messages\n", s, summ_ib[s]+summ_ob[s],summ_im[s]+summ_om[s] 
	}
	if (t_nb != t_bytes || t_nm != t_msgs)
		printf "ERROR - Internal checksum error - [%ld, %ld] bytes, [%ld, %ld] msgs\n", t_nb, t_bytes, t_nm, t_msgs
}
